﻿
function getDeviceId() {
 var deviceId = getCookie('DeviceId');
 if (deviceId == null) {
  deviceId = localStorage.getItem('DeviceId');
  setCookie('DeviceId', deviceId, 365);
 }
 return deviceId;
}

function setDeviceId(deviceId) {
 setCookie('DeviceId', deviceId, 365);
 localStorage.setItem('DeviceId',deviceId);
}

function setCookie(name, value, days) {
 var expires = "";
 var date = new Date();
 if (days) {
  date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
 }
 else {
  date.setTime(date.getTime() + (30 * 24 * 60 * 60 * 1000));
 }
 expires = "; expires=" + date.toUTCString();
 document.cookie = name + "=" + (value || "") + expires + "; path=/";
}

function getCookie(name) {
 var cookieArr = document.cookie.split(";");
 for (var i = 0; i < cookieArr.length; i++) {
  var cookiePair = cookieArr[i].split("=");
  if (name == cookiePair[0].trim()) {
   return decodeURIComponent(cookiePair[1]);
  }
 }
 return null;
}

function getCanvasSize(id) {
 var canvas = document.getElementById(id);
 var style = window.getComputedStyle(canvas);
 var height = $(window).height();
 return [canvas.clientWidth, height - canvas.offsetTop - (parseFloat(style.marginBottom) + 2)];
}

function getViewPortRatio() {
 return window.innerWidth / window.innerHeight;
}

function getCanvasLocation(id) {
 var canvas = document.getElementById(id);
 return [canvas.offsetLeft, canvas.offsetTop];
}

var helper;
window.addEventListener("resize", resizedWindow);

function resizedWindow() {
 if (helper != null) {
  helper.invokeMethodAsync('OnBrowserResize').then(data => data);
 } else {
  console.log('helper missing');
 }
};

function RegisterHelper(dotnetHelper) {
 helper = dotnetHelper;
}

function UnregisterHelper() {
 helper = null;
}


function SaveAsFile(filename, typ, bytesBase64) {
 if (navigator.msSaveBlob) {
  //Download document in Edge browser
  var data = window.atob(bytesBase64);
  var bytes = new Uint8Array(data.length);
  for (var i = 0; i < data.length; i++) {
   bytes[i] = data.charCodeAt(i);
  }
  var blob = new Blob([bytes.buffer], { type: typ });
  navigator.msSaveBlob(blob, filename);
 }
 else {
  var link = document.createElement('a');
  link.download = filename;
  link.href = "data:" + typ + ";base64," + bytesBase64;
  document.body.appendChild(link); // Needed for Firefox
  link.click();
  document.body.removeChild(link);
 }
}
