"use strict";function getBoundingClientRect(e){e=e.getBoundingClientRect();return{width:e.width,height:e.height,top:e.top,right:e.right,bottom:e.bottom,left:e.left,x:e.left,y:e.top}}function getWindow(e){if("[object Window]"===e.toString())return e;e=e.ownerDocument;return e&&e.defaultView||window}function getWindowScroll(e){e=getWindow(e);return{scrollLeft:e.pageXOffset,scrollTop:e.pageYOffset}}function isElement(e){return e instanceof getWindow(e).Element||e instanceof Element}function isHTMLElement(e){return e instanceof getWindow(e).HTMLElement||e instanceof HTMLElement}function isShadowRoot(e){return e instanceof getWindow(e).ShadowRoot||e instanceof ShadowRoot}function getHTMLElementScroll(e){return{scrollLeft:e.scrollLeft,scrollTop:e.scrollTop}}function getNodeScroll(e){return(e!==getWindow(e)&&isHTMLElement(e)?getHTMLElementScroll:getWindowScroll)(e)}function getNodeName(e){return e?(e.nodeName||"").toLowerCase():null}function getDocumentElement(e){return((isElement(e)?e.ownerDocument:e.document)||window.document).documentElement}function getWindowScrollBarX(e){return getBoundingClientRect(getDocumentElement(e)).left+getWindowScroll(e).scrollLeft}function getComputedStyle(e){return getWindow(e).getComputedStyle(e)}function isScrollParent(e){var t=getComputedStyle(e),n=t.overflow,e=t.overflowX,t=t.overflowY;return/auto|scroll|overlay|hidden/.test(n+t+e)}function getCompositeRect(e,t,n){void 0===n&&(n=!1);var o=getDocumentElement(t),r=getBoundingClientRect(e),i=isHTMLElement(t),a={scrollLeft:0,scrollTop:0},e={x:0,y:0};return!i&&(i||n)||("body"===getNodeName(t)&&!isScrollParent(o)||(a=getNodeScroll(t)),isHTMLElement(t)?((e=getBoundingClientRect(t)).x+=t.clientLeft,e.y+=t.clientTop):o&&(e.x=getWindowScrollBarX(o))),{x:r.left+a.scrollLeft-e.x,y:r.top+a.scrollTop-e.y,width:r.width,height:r.height}}function getLayoutRect(e){return{x:e.offsetLeft,y:e.offsetTop,width:e.offsetWidth,height:e.offsetHeight}}function getParentNode(e){return"html"===getNodeName(e)?e:e.assignedSlot||e.parentNode||e.host||getDocumentElement(e)}function getScrollParent(e){return 0<=["html","body","#document"].indexOf(getNodeName(e))?e.ownerDocument.body:isHTMLElement(e)&&isScrollParent(e)?e:getScrollParent(getParentNode(e))}function listScrollParents(e,t){void 0===t&&(t=[]);var n=getScrollParent(e),o="body"===getNodeName(n),e=getWindow(n),n=o?[e].concat(e.visualViewport||[],isScrollParent(n)?n:[]):n,t=t.concat(n);return o?t:t.concat(listScrollParents(getParentNode(n)))}function isTableElement(e){return 0<=["table","td","th"].indexOf(getNodeName(e))}function getTrueOffsetParent(e){if(!isHTMLElement(e)||"fixed"===getComputedStyle(e).position)return null;var t=e.offsetParent;if(t){e=getDocumentElement(t);if("body"===getNodeName(t)&&"static"===getComputedStyle(t).position&&"static"!==getComputedStyle(e).position)return e}return t}function getContainingBlock(e){for(var t=getParentNode(e);isHTMLElement(t)&&["html","body"].indexOf(getNodeName(t))<0;){var n=getComputedStyle(t);if("none"!==n.transform||"none"!==n.perspective||n.willChange&&"auto"!==n.willChange)return t;t=t.parentNode}return null}function getOffsetParent(e){for(var t=getWindow(e),n=getTrueOffsetParent(e);n&&isTableElement(n)&&"static"===getComputedStyle(n).position;)n=getTrueOffsetParent(n);return(!n||"body"!==getNodeName(n)||"static"!==getComputedStyle(n).position)&&(n||getContainingBlock(e))||t}Object.defineProperty(exports,"__esModule",{value:!0});var top="top",bottom="bottom",right="right",left="left",auto="auto",basePlacements=[top,bottom,right,left],start="start",end="end",clippingParents="clippingParents",viewport="viewport",popper="popper",reference="reference",variationPlacements=basePlacements.reduce(function(e,t){return e.concat([t+"-"+start,t+"-"+end])},[]),placements=[].concat(basePlacements,[auto]).reduce(function(e,t){return e.concat([t,t+"-"+start,t+"-"+end])},[]),beforeRead="beforeRead",read="read",afterRead="afterRead",beforeMain="beforeMain",main="main",afterMain="afterMain",beforeWrite="beforeWrite",write="write",afterWrite="afterWrite",modifierPhases=[beforeRead,read,afterRead,beforeMain,main,afterMain,beforeWrite,write,afterWrite];function order(e){var n=new Map,o=new Set,r=[];return e.forEach(function(e){n.set(e.name,e)}),e.forEach(function(e){o.has(e.name)||!function t(e){o.add(e.name),[].concat(e.requires||[],e.requiresIfExists||[]).forEach(function(e){o.has(e)||(e=n.get(e))&&t(e)}),r.push(e)}(e)}),r}function orderModifiers(e){var n=order(e);return modifierPhases.reduce(function(e,t){return e.concat(n.filter(function(e){return e.phase===t}))},[])}function debounce(t){var n;return function(){return n=n||new Promise(function(e){Promise.resolve().then(function(){n=void 0,e(t())})})}}function format(e){for(var t=arguments.length,n=new Array(1<t?t-1:0),o=1;o<t;o++)n[o-1]=arguments[o];return[].concat(n).reduce(function(e,t){return e.replace(/%s/,t)},e)}var INVALID_MODIFIER_ERROR='Popper: modifier "%s" provided an invalid %s property, expected %s but got %s',MISSING_DEPENDENCY_ERROR='Popper: modifier "%s" requires "%s", but "%s" modifier is not available',VALID_PROPERTIES=["name","enabled","phase","fn","effect","requires","options"];function validateModifiers(o){o.forEach(function(n){Object.keys(n).forEach(function(e){switch(e){case"name":"string"!=typeof n.name&&console.error(format(INVALID_MODIFIER_ERROR,String(n.name),'"name"','"string"','"'+String(n.name)+'"'));break;case"enabled":"boolean"!=typeof n.enabled&&console.error(format(INVALID_MODIFIER_ERROR,n.name,'"enabled"','"boolean"','"'+String(n.enabled)+'"'));case"phase":modifierPhases.indexOf(n.phase)<0&&console.error(format(INVALID_MODIFIER_ERROR,n.name,'"phase"',"either "+modifierPhases.join(", "),'"'+String(n.phase)+'"'));break;case"fn":"function"!=typeof n.fn&&console.error(format(INVALID_MODIFIER_ERROR,n.name,'"fn"','"function"','"'+String(n.fn)+'"'));break;case"effect":"function"!=typeof n.effect&&console.error(format(INVALID_MODIFIER_ERROR,n.name,'"effect"','"function"','"'+String(n.fn)+'"'));break;case"requires":Array.isArray(n.requires)||console.error(format(INVALID_MODIFIER_ERROR,n.name,'"requires"','"array"','"'+String(n.requires)+'"'));break;case"requiresIfExists":Array.isArray(n.requiresIfExists)||console.error(format(INVALID_MODIFIER_ERROR,n.name,'"requiresIfExists"','"array"','"'+String(n.requiresIfExists)+'"'));break;case"options":case"data":break;default:console.error('PopperJS: an invalid property has been provided to the "'+n.name+'" modifier, valid properties are '+VALID_PROPERTIES.map(function(e){return'"'+e+'"'}).join(", ")+'; but "'+e+'" was provided.')}n.requires&&n.requires.forEach(function(t){null==o.find(function(e){return e.name===t})&&console.error(format(MISSING_DEPENDENCY_ERROR,String(n.name),t,t))})})})}function uniqueBy(e,t){var n=new Set;return e.filter(function(e){e=t(e);if(!n.has(e))return n.add(e),!0})}function getBasePlacement(e){return e.split("-")[0]}function mergeByName(e){var t=e.reduce(function(e,t){var n=e[t.name];return e[t.name]=n?Object.assign(Object.assign(Object.assign({},n),t),{},{options:Object.assign(Object.assign({},n.options),t.options),data:Object.assign(Object.assign({},n.data),t.data)}):t,e},{});return Object.keys(t).map(function(e){return t[e]})}function getViewportRect(e){var t=getWindow(e),n=getDocumentElement(e),o=t.visualViewport,r=n.clientWidth,i=n.clientHeight,t=0,n=0;return o&&(r=o.width,i=o.height,/^((?!chrome|android).)*safari/i.test(navigator.userAgent)||(t=o.offsetLeft,n=o.offsetTop)),{width:r,height:i,x:t+getWindowScrollBarX(e),y:n}}function getDocumentRect(e){var t=getDocumentElement(e),n=getWindowScroll(e),o=e.ownerDocument.body,r=Math.max(t.scrollWidth,t.clientWidth,o?o.scrollWidth:0,o?o.clientWidth:0),i=Math.max(t.scrollHeight,t.clientHeight,o?o.scrollHeight:0,o?o.clientHeight:0),e=-n.scrollLeft+getWindowScrollBarX(e),n=-n.scrollTop;return"rtl"===getComputedStyle(o||t).direction&&(e+=Math.max(t.clientWidth,o?o.clientWidth:0)-r),{width:r,height:i,x:e,y:n}}function contains(e,t){var n=t.getRootNode&&t.getRootNode();if(e.contains(t))return!0;if(n&&isShadowRoot(n)){var o=t;do{if(o&&e.isSameNode(o))return!0}while(o=o.parentNode||o.host)}return!1}function rectToClientRect(e){return Object.assign(Object.assign({},e),{},{left:e.x,top:e.y,right:e.x+e.width,bottom:e.y+e.height})}function getInnerBoundingClientRect(e){var t=getBoundingClientRect(e);return t.top=t.top+e.clientTop,t.left=t.left+e.clientLeft,t.bottom=t.top+e.clientHeight,t.right=t.left+e.clientWidth,t.width=e.clientWidth,t.height=e.clientHeight,t.x=t.left,t.y=t.top,t}function getClientRectFromMixedType(e,t){return t===viewport?rectToClientRect(getViewportRect(e)):isHTMLElement(t)?getInnerBoundingClientRect(t):rectToClientRect(getDocumentRect(getDocumentElement(e)))}function getClippingParents(e){var t=listScrollParents(getParentNode(e)),n=0<=["absolute","fixed"].indexOf(getComputedStyle(e).position)&&isHTMLElement(e)?getOffsetParent(e):e;return isElement(n)?t.filter(function(e){return isElement(e)&&contains(e,n)&&"body"!==getNodeName(e)}):[]}function getClippingRect(n,e,t){e="clippingParents"===e?getClippingParents(n):[].concat(e),e=[].concat(e,[t]),t=e[0],t=e.reduce(function(e,t){t=getClientRectFromMixedType(n,t);return e.top=Math.max(t.top,e.top),e.right=Math.min(t.right,e.right),e.bottom=Math.min(t.bottom,e.bottom),e.left=Math.max(t.left,e.left),e},getClientRectFromMixedType(n,t));return t.width=t.right-t.left,t.height=t.bottom-t.top,t.x=t.left,t.y=t.top,t}function getVariation(e){return e.split("-")[1]}function getMainAxisFromPlacement(e){return 0<=["top","bottom"].indexOf(e)?"x":"y"}function computeOffsets(e){var t,n=e.reference,o=e.element,r=e.placement,i=r?getBasePlacement(r):null,a=r?getVariation(r):null,e=n.x+n.width/2-o.width/2,r=n.y+n.height/2-o.height/2;switch(i){case top:t={x:e,y:n.y-o.height};break;case bottom:t={x:e,y:n.y+n.height};break;case right:t={x:n.x+n.width,y:r};break;case left:t={x:n.x-o.width,y:r};break;default:t={x:n.x,y:n.y}}r=i?getMainAxisFromPlacement(i):null;if(null!=r){i="y"===r?"height":"width";switch(a){case start:t[r]=t[r]-(n[i]/2-o[i]/2);break;case end:t[r]=t[r]+(n[i]/2-o[i]/2)}}return t}function getFreshSideObject(){return{top:0,right:0,bottom:0,left:0}}function mergePaddingObject(e){return Object.assign(Object.assign({},getFreshSideObject()),e)}function expandToHashMap(n,e){return e.reduce(function(e,t){return e[t]=n,e},{})}function detectOverflow(e,t){void 0===t&&(t={});var o,n=t.placement,r=void 0===n?e.placement:n,i=t.boundary,a=void 0===i?clippingParents:i,s=t.rootBoundary,p=void 0===s?viewport:s,c=t.elementContext,f=void 0===c?popper:c,n=t.altBoundary,i=void 0!==n&&n,s=t.padding,c=void 0===s?0:s,n=mergePaddingObject("number"!=typeof c?c:expandToHashMap(c,basePlacements)),t=f===popper?reference:popper,s=e.elements.reference,c=e.rects.popper,t=e.elements[i?t:f],a=getClippingRect(isElement(t)?t:t.contextElement||getDocumentElement(e.elements.popper),a,p),p=getBoundingClientRect(s),s=computeOffsets({reference:p,element:c,strategy:"absolute",placement:r}),s=rectToClientRect(Object.assign(Object.assign({},c),s)),p=f===popper?s:p,l={top:a.top-p.top+n.top,bottom:p.bottom-a.bottom+n.bottom,left:a.left-p.left+n.left,right:p.right-a.right+n.right},e=e.modifiersData.offset;return f===popper&&e&&(o=e[r],Object.keys(l).forEach(function(e){var t=0<=[right,bottom].indexOf(e)?1:-1,n=0<=[top,bottom].indexOf(e)?"y":"x";l[e]+=o[n]*t})),l}var INVALID_ELEMENT_ERROR="Popper: Invalid reference or popper argument provided. They must be either a DOM element or virtual element.",INFINITE_LOOP_ERROR="Popper: An infinite loop in the modifiers cycle has been detected! The cycle has been interrupted to prevent a browser crash.",DEFAULT_OPTIONS={placement:"bottom",modifiers:[],strategy:"absolute"};function areValidElements(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return!t.some(function(e){return!(e&&"function"==typeof e.getBoundingClientRect)})}function popperGenerator(e){void 0===e&&(e={});var t=e.defaultModifiers,a=void 0===t?[]:t,e=e.defaultOptions,f=void 0===e?DEFAULT_OPTIONS:e;return function(t,n,o){void 0===o&&(o=f);var s={placement:"bottom",orderedModifiers:[],options:Object.assign(Object.assign({},DEFAULT_OPTIONS),f),modifiersData:{},elements:{reference:t,popper:n},attributes:{},styles:{}},r=[],p=!1,c={state:s,setOptions:function(e){i(),s.options=Object.assign(Object.assign(Object.assign({},f),s.options),e),s.scrollParents={reference:isElement(t)?listScrollParents(t):t.contextElement?listScrollParents(t.contextElement):[],popper:listScrollParents(n)};e=orderModifiers(mergeByName([].concat(a,s.options.modifiers)));return s.orderedModifiers=e.filter(function(e){return e.enabled}),"production"!==process.env.NODE_ENV&&(validateModifiers(uniqueBy([].concat(e,s.options.modifiers),function(e){return e.name})),getBasePlacement(s.options.placement)===auto&&(s.orderedModifiers.find(function(e){return"flip"===e.name})||console.error(['Popper: "auto" placements require the "flip" modifier be',"present and enabled to work."].join(" "))),[(e=getComputedStyle(n)).marginTop,e.marginRight,e.marginBottom,e.marginLeft].some(function(e){return parseFloat(e)})&&console.warn(['Popper: CSS "margin" styles cannot be used to apply padding',"between the popper and its reference element or boundary.","To replicate margin, use the `offset` modifier, as well as","the `padding` option in the `preventOverflow` and `flip`","modifiers."].join(" "))),s.orderedModifiers.forEach(function(e){var t=e.name,n=e.options,n=void 0===n?{}:n,e=e.effect;"function"==typeof e&&(n=e({state:s,name:t,instance:c,options:n}),r.push(n||function(){}))}),c.update()},forceUpdate:function(){if(!p){var e=s.elements,t=e.reference,e=e.popper;if(areValidElements(t,e)){s.rects={reference:getCompositeRect(t,getOffsetParent(e),"fixed"===s.options.strategy),popper:getLayoutRect(e)},s.reset=!1,s.placement=s.options.placement,s.orderedModifiers.forEach(function(e){return s.modifiersData[e.name]=Object.assign({},e.data)});for(var n,o,r,i=0,a=0;a<s.orderedModifiers.length;a++){if("production"!==process.env.NODE_ENV&&100<(i+=1)){console.error(INFINITE_LOOP_ERROR);break}!0!==s.reset?(n=(r=s.orderedModifiers[a]).fn,o=void 0===(o=r.options)?{}:o,r=r.name,"function"==typeof n&&(s=n({state:s,options:o,name:r,instance:c})||s)):(s.reset=!1,a=-1)}}else"production"!==process.env.NODE_ENV&&console.error(INVALID_ELEMENT_ERROR)}},update:debounce(function(){return new Promise(function(e){c.forceUpdate(),e(s)})}),destroy:function(){i(),p=!0}};return areValidElements(t,n)?c.setOptions(o).then(function(e){!p&&o.onFirstUpdate&&o.onFirstUpdate(e)}):"production"!==process.env.NODE_ENV&&console.error(INVALID_ELEMENT_ERROR),c;function i(){r.forEach(function(e){return e()}),r=[]}}}var passive={passive:!0};function effect(e){var t=e.state,n=e.instance,o=e.options,e=o.scroll,r=void 0===e||e,o=o.resize,i=void 0===o||o,a=getWindow(t.elements.popper),s=[].concat(t.scrollParents.reference,t.scrollParents.popper);return r&&s.forEach(function(e){e.addEventListener("scroll",n.update,passive)}),i&&a.addEventListener("resize",n.update,passive),function(){r&&s.forEach(function(e){e.removeEventListener("scroll",n.update,passive)}),i&&a.removeEventListener("resize",n.update,passive)}}var eventListeners={name:"eventListeners",enabled:!0,phase:"write",fn:function(){},effect:effect,data:{}};function popperOffsets(e){var t=e.state,e=e.name;t.modifiersData[e]=computeOffsets({reference:t.rects.reference,element:t.rects.popper,strategy:"absolute",placement:t.placement})}var popperOffsets$1={name:"popperOffsets",enabled:!0,phase:"read",fn:popperOffsets,data:{}},unsetSides={top:"auto",right:"auto",bottom:"auto",left:"auto"};function roundOffsetsByDPR(e){var t=e.x,n=e.y,e=window.devicePixelRatio||1;return{x:Math.round(t*e)/e||0,y:Math.round(n*e)/e||0}}function mapToStyles(e){var t=e.popper,n=e.popperRect,o=e.placement,r=e.offsets,i=e.position,a=e.gpuAcceleration,s=e.adaptive,p=e.roundOffsets?roundOffsetsByDPR(r):r,c=p.x,f=void 0===c?0:c,l=p.y,d=void 0===l?0:l,u=r.hasOwnProperty("x"),e=r.hasOwnProperty("y"),c=left,p=top,l=window;s&&((r=getOffsetParent(t))===getWindow(t)&&(r=getDocumentElement(t)),o===top&&(p=bottom,d-=r.clientHeight-n.height,d*=a?1:-1),o===left&&(c=right,f-=r.clientWidth-n.width,f*=a?1:-1));var s=Object.assign({position:i},s&&unsetSides);return a?Object.assign(Object.assign({},s),{},((a={})[p]=e?"0":"",a[c]=u?"0":"",a.transform=(l.devicePixelRatio||1)<2?"translate("+f+"px, "+d+"px)":"translate3d("+f+"px, "+d+"px, 0)",a)):Object.assign(Object.assign({},s),{},((s={})[p]=e?d+"px":"",s[c]=u?f+"px":"",s.transform="",s))}function computeStyles(e){var t,n=e.state,o=e.options,r=o.gpuAcceleration,e=void 0===r||r,r=o.adaptive,r=void 0===r||r,o=o.roundOffsets,o=void 0===o||o;"production"!==process.env.NODE_ENV&&(t=getComputedStyle(n.elements.popper).transitionProperty||"",r&&["transform","top","right","bottom","left"].some(function(e){return 0<=t.indexOf(e)})&&console.warn(["Popper: Detected CSS transitions on at least one of the following",'CSS properties: "transform", "top", "right", "bottom", "left".',"\n\n",'Disable the "computeStyles" modifier\'s `adaptive` option to allow',"for smooth transitions, or remove these properties from the CSS","transition declaration on the popper element if only transitioning","opacity or background-color for example.","\n\n","We recommend using the popper element as a wrapper around an inner","element that can have any CSS property transitioned for animations."].join(" ")));e={placement:getBasePlacement(n.placement),popper:n.elements.popper,popperRect:n.rects.popper,gpuAcceleration:e};null!=n.modifiersData.popperOffsets&&(n.styles.popper=Object.assign(Object.assign({},n.styles.popper),mapToStyles(Object.assign(Object.assign({},e),{},{offsets:n.modifiersData.popperOffsets,position:n.options.strategy,adaptive:r,roundOffsets:o})))),null!=n.modifiersData.arrow&&(n.styles.arrow=Object.assign(Object.assign({},n.styles.arrow),mapToStyles(Object.assign(Object.assign({},e),{},{offsets:n.modifiersData.arrow,position:"absolute",adaptive:!1,roundOffsets:o})))),n.attributes.popper=Object.assign(Object.assign({},n.attributes.popper),{},{"data-popper-placement":n.placement})}var computeStyles$1={name:"computeStyles",enabled:!0,phase:"beforeWrite",fn:computeStyles,data:{}};function applyStyles(e){var r=e.state;Object.keys(r.elements).forEach(function(e){var t=r.styles[e]||{},n=r.attributes[e]||{},o=r.elements[e];isHTMLElement(o)&&getNodeName(o)&&(Object.assign(o.style,t),Object.keys(n).forEach(function(e){var t=n[e];!1===t?o.removeAttribute(e):o.setAttribute(e,!0===t?"":t)}))})}function effect$1(e){var o=e.state,r={popper:{position:o.options.strategy,left:"0",top:"0",margin:"0"},arrow:{position:"absolute"},reference:{}};return Object.assign(o.elements.popper.style,r.popper),o.elements.arrow&&Object.assign(o.elements.arrow.style,r.arrow),function(){Object.keys(o.elements).forEach(function(e){var t=o.elements[e],n=o.attributes[e]||{},e=Object.keys((o.styles.hasOwnProperty(e)?o.styles:r)[e]).reduce(function(e,t){return e[t]="",e},{});isHTMLElement(t)&&getNodeName(t)&&(Object.assign(t.style,e),Object.keys(n).forEach(function(e){t.removeAttribute(e)}))})}}var applyStyles$1={name:"applyStyles",enabled:!0,phase:"write",fn:applyStyles,effect:effect$1,requires:["computeStyles"]};function distanceAndSkiddingToXY(e,t,n){var o=getBasePlacement(e),r=0<=[left,top].indexOf(o)?-1:1,e="function"==typeof n?n(Object.assign(Object.assign({},t),{},{placement:e})):n,n=(n=e[0])||0,e=((e=e[1])||0)*r;return 0<=[left,right].indexOf(o)?{x:e,y:n}:{x:n,y:e}}function offset(e){var n=e.state,t=e.options,o=e.name,r=t.offset,i=void 0===r?[0,0]:r,e=placements.reduce(function(e,t){return e[t]=distanceAndSkiddingToXY(t,n.rects,i),e},{}),t=e[n.placement],r=t.x,t=t.y;null!=n.modifiersData.popperOffsets&&(n.modifiersData.popperOffsets.x+=r,n.modifiersData.popperOffsets.y+=t),n.modifiersData[o]=e}var offset$1={name:"offset",enabled:!0,phase:"main",requires:["popperOffsets"],fn:offset},hash={left:"right",right:"left",bottom:"top",top:"bottom"};function getOppositePlacement(e){return e.replace(/left|right|bottom|top/g,function(e){return hash[e]})}var hash$1={start:"end",end:"start"};function getOppositeVariationPlacement(e){return e.replace(/start|end/g,function(e){return hash$1[e]})}function computeAutoPlacement(n,e){void 0===e&&(e={});var t=e.placement,o=e.boundary,r=e.rootBoundary,i=e.padding,a=e.flipVariations,e=e.allowedAutoPlacements,s=void 0===e?placements:e,p=getVariation(t),t=p?a?variationPlacements:variationPlacements.filter(function(e){return getVariation(e)===p}):basePlacements,a=t.filter(function(e){return 0<=s.indexOf(e)});0===a.length&&(a=t,"production"!==process.env.NODE_ENV&&console.error(["Popper: The `allowedAutoPlacements` option did not allow any","placements. Ensure the `placement` option matches the variation","of the allowed placements.",'For example, "auto" cannot be used to allow "bottom-start".','Use "auto-start" instead.'].join(" ")));var c=a.reduce(function(e,t){return e[t]=detectOverflow(n,{placement:t,boundary:o,rootBoundary:r,padding:i})[getBasePlacement(t)],e},{});return Object.keys(c).sort(function(e,t){return c[e]-c[t]})}function getExpandedFallbackPlacements(e){if(getBasePlacement(e)===auto)return[];var t=getOppositePlacement(e);return[getOppositeVariationPlacement(e),t,getOppositeVariationPlacement(t)]}function flip(e){var n=e.state,t=e.options,o=e.name;if(!n.modifiersData[o]._skip){for(var r=t.mainAxis,i=void 0===r||r,e=t.altAxis,a=void 0===e||e,r=t.fallbackPlacements,s=t.padding,p=t.boundary,c=t.rootBoundary,f=t.altBoundary,e=t.flipVariations,l=void 0===e||e,d=t.allowedAutoPlacements,e=n.options.placement,t=getBasePlacement(e),t=r||(t===e||!l?[getOppositePlacement(e)]:getExpandedFallbackPlacements(e)),u=[e].concat(t).reduce(function(e,t){return e.concat(getBasePlacement(t)===auto?computeAutoPlacement(n,{placement:t,boundary:p,rootBoundary:c,padding:s,flipVariations:l,allowedAutoPlacements:d}):t)},[]),m=n.rects.reference,g=n.rects.popper,h=new Map,b=!0,y=u[0],v=0;v<u.length;v++){var O=u[v],w=getBasePlacement(O),E=getVariation(O)===start,P=0<=[top,bottom].indexOf(w),x=P?"width":"height",S=detectOverflow(n,{placement:O,boundary:p,rootBoundary:c,altBoundary:f,padding:s}),P=P?E?right:left:E?bottom:top;m[x]>g[x]&&(P=getOppositePlacement(P));E=getOppositePlacement(P),x=[];if(i&&x.push(S[w]<=0),a&&x.push(S[P]<=0,S[E]<=0),x.every(function(e){return e})){y=O,b=!1;break}h.set(O,x)}if(b)for(var R=l?3:1;0<R;R--)if("break"===function(t){var e=u.find(function(e){e=h.get(e);if(e)return e.slice(0,t).every(function(e){return e})});if(e)return y=e,"break"}(R))break;n.placement!==y&&(n.modifiersData[o]._skip=!0,n.placement=y,n.reset=!0)}}var flip$1={name:"flip",enabled:!0,phase:"main",fn:flip,requiresIfExists:["offset"],data:{_skip:!1}};function getAltAxis(e){return"x"===e?"y":"x"}function within(e,t,n){return Math.max(e,Math.min(t,n))}function preventOverflow(e){var t,n=e.state,o=e.options,r=e.name,i=o.mainAxis,a=void 0===i||i,s=o.altAxis,p=void 0!==s&&s,c=o.boundary,f=o.rootBoundary,l=o.altBoundary,d=o.padding,u=o.tether,m=void 0===u||u,g=o.tetherOffset,h=void 0===g?0:g,b=detectOverflow(n,{boundary:c,rootBoundary:f,padding:d,altBoundary:l}),y=getBasePlacement(n.placement),v=getVariation(n.placement),O=!v,w=getMainAxisFromPlacement(y),E=getAltAxis(w),e=n.modifiersData.popperOffsets,i=n.rects.reference,s=n.rects.popper,u="function"==typeof h?h(Object.assign(Object.assign({},n.rects),{},{placement:n.placement})):h,o={x:0,y:0};e&&(a&&(g="y"===w?top:left,c="y"===w?bottom:right,f="y"===w?"height":"width",t=e[w],d=e[w]+b[g],l=e[w]-b[c],y=m?-s[f]/2:0,h=(v===start?i:s)[f],a=v===start?-s[f]:-i[f],v=n.elements.arrow,s=m&&v?getLayoutRect(v):{width:0,height:0},g=(v=n.modifiersData["arrow#persistent"]?n.modifiersData["arrow#persistent"].padding:getFreshSideObject())[g],c=v[c],s=within(0,i[f],s[f]),g=O?i[f]/2-y-s-g-u:h-s-g-u,s=O?-i[f]/2+y+s+c+u:a+s+c+u,u=(c=n.elements.arrow&&getOffsetParent(n.elements.arrow))?"y"===w?c.clientTop||0:c.clientLeft||0:0,c=n.modifiersData.offset?n.modifiersData.offset[n.placement][w]:0,u=e[w]+g-c-u,c=e[w]+s-c,l=within(m?Math.min(d,u):d,t,m?Math.max(l,c):l),e[w]=l,o[w]=l-t),p&&(t="x"===w?top:left,p="x"===w?bottom:right,p=within((w=e[E])+b[t],w,w-b[p]),e[E]=p,o[E]=p-w),n.modifiersData[r]=o)}var preventOverflow$1={name:"preventOverflow",enabled:!0,phase:"main",fn:preventOverflow,requiresIfExists:["offset"]};function arrow(e){var t,n,o,r=e.state,i=e.name,a=r.elements.arrow,s=r.modifiersData.popperOffsets,p=getBasePlacement(r.placement),c=getMainAxisFromPlacement(p),f=0<=[left,right].indexOf(p)?"height":"width";a&&s&&(t=r.modifiersData[i+"#persistent"].padding,n=getLayoutRect(a),o="y"===c?top:left,e="y"===c?bottom:right,p=r.rects.reference[f]+r.rects.reference[c]-s[c]-r.rects.popper[f],s=s[c]-r.rects.reference[c],a=(a=getOffsetParent(a))?"y"===c?a.clientHeight||0:a.clientWidth||0:0,s=p/2-s/2,o=t[o],e=a-n[f]-t[e],e=within(o,s=a/2-n[f]/2+s,e),r.modifiersData[i]=((i={})[c]=e,i.centerOffset=e-s,i))}function effect$2(e){var t=e.state,n=e.options,o=e.name,e=n.element,e=void 0===e?"[data-popper-arrow]":e,n=n.padding,n=void 0===n?0:n;null!=e&&("string"==typeof e&&!(e=t.elements.popper.querySelector(e))||("production"!==process.env.NODE_ENV&&(isHTMLElement(e)||console.error(['Popper: "arrow" element must be an HTMLElement (not an SVGElement).',"To use an SVG arrow, wrap it in an HTMLElement that will be used as","the arrow."].join(" "))),contains(t.elements.popper,e)?(t.elements.arrow=e,t.modifiersData[o+"#persistent"]={padding:mergePaddingObject("number"!=typeof n?n:expandToHashMap(n,basePlacements))}):"production"!==process.env.NODE_ENV&&console.error(['Popper: "arrow" modifier\'s `element` must be a child of the popper',"element."].join(" "))))}var arrow$1={name:"arrow",enabled:!0,phase:"main",fn:arrow,effect:effect$2,requires:["popperOffsets"],requiresIfExists:["preventOverflow"]};function getSideOffsets(e,t,n){return void 0===n&&(n={x:0,y:0}),{top:e.top-t.height-n.y,right:e.right-t.width+n.x,bottom:e.bottom-t.height+n.y,left:e.left-t.width-n.x}}function isAnySideFullyClipped(t){return[top,right,bottom,left].some(function(e){return 0<=t[e]})}function hide(e){var t=e.state,n=e.name,o=t.rects.reference,r=t.rects.popper,i=t.modifiersData.preventOverflow,a=detectOverflow(t,{elementContext:"reference"}),e=detectOverflow(t,{altBoundary:!0}),o=getSideOffsets(a,o),e=getSideOffsets(e,r,i),r=isAnySideFullyClipped(o),i=isAnySideFullyClipped(e);t.modifiersData[n]={referenceClippingOffsets:o,popperEscapeOffsets:e,isReferenceHidden:r,hasPopperEscaped:i},t.attributes.popper=Object.assign(Object.assign({},t.attributes.popper),{},{"data-popper-reference-hidden":r,"data-popper-escaped":i})}var hide$1={name:"hide",enabled:!0,phase:"main",requiresIfExists:["preventOverflow"],fn:hide},defaultModifiers=[eventListeners,popperOffsets$1,computeStyles$1,applyStyles$1],createPopper=popperGenerator({defaultModifiers:defaultModifiers}),defaultModifiers$1=[eventListeners,popperOffsets$1,computeStyles$1,applyStyles$1,offset$1,flip$1,preventOverflow$1,arrow$1,hide$1],createPopper$1=popperGenerator({defaultModifiers:defaultModifiers$1});exports.applyStyles=applyStyles$1,exports.arrow=arrow$1,exports.computeStyles=computeStyles$1,exports.createPopper=createPopper$1,exports.createPopperLite=createPopper,exports.defaultModifiers=defaultModifiers$1,exports.detectOverflow=detectOverflow,exports.eventListeners=eventListeners,exports.flip=flip$1,exports.hide=hide$1,exports.offset=offset$1,exports.popperGenerator=popperGenerator,exports.popperOffsets=popperOffsets$1,exports.preventOverflow=preventOverflow$1;