﻿function hideElementParent(id) {
 var element = document.getElementById(id);
 if (element != null) {
  element.parentElement.hidden = true;
 }
}

function clickElement(id) {
 var element = document.getElementById(id);
 if (element != null) {
  element.click();
 }
}

function downloadFile(fileName, link) {
 var linkElement = document.createElement("a");
 linkElement.href = link;
 linkElement.download = fileName;
 linkElement.click();
}

function TimeoutRefresh(interval) {
 console.log('timeoutstarted');
 setTimeout(function () {
  var element = document.getElementById('device-id-loader');
  if (element != null) {
   location.reload();
   console.log('reloaded');
  }
  else {
   console.log('timeoutstoped');
  }
 }, interval);
}

function getDeviceId() {
 setScreenRatio();
 var deviceId = getCookie('DeviceId');
 if (deviceId == null) {
  try {
   deviceId = localStorage.getItem('DeviceId');
   setCookie('DeviceId', deviceId, 365);
  }
  catch (err) {}  
 }
 return deviceId;
}

function setDeviceId(deviceId) {
 setCookie('DeviceId', deviceId, 365);
 try {
  localStorage.setItem('DeviceId', deviceId);
 }
 catch (err) {}
}

function setCookie(name, value, days) {
 var expires = "";
 var date = new Date();
 if (days) {
  date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
 }
 else {
  date.setTime(date.getTime() + (30 * 24 * 60 * 60 * 1000));
 }
 expires = "; expires=" + date.toUTCString();
 document.cookie = name + "=" + (value || "") + expires + "; path=/";
}

function setPushButtonCount(buttonCount) {
 document.documentElement.style.setProperty('--pushbutton-count', buttonCount);
}

function setScreenRatio() {
 var ratio = window.innerWidth / window.innerHeight;
 document.documentElement.style.setProperty('--screen-ratio', ratio);
 setCalendarSize();
}

function setCalendarSize() {
 var leftMenuWidth = getPixelsInRem() * parseFloat(getComputedStyle(document.documentElement).getPropertyValue('--left-menu-width'));
 var topMenuHeight = getPixelsInRem() * parseFloat(getComputedStyle(document.documentElement).getPropertyValue('--top-menu-height'));
 var spaceRatio = (window.innerWidth - leftMenuWidth) / (window.innerHeight - topMenuHeight);
 var calRatio = 1.59;
 if (spaceRatio > calRatio) {
  document.documentElement.style.setProperty('--calendar-width', ((window.innerHeight - topMenuHeight) * calRatio).toString() + 'px');
  document.documentElement.style.setProperty('--calendar-height', (window.innerHeight - topMenuHeight).toString() + 'px');
 } else {
  document.documentElement.style.setProperty('--calendar-width', (window.innerWidth - leftMenuWidth).toString() + 'px');
  document.documentElement.style.setProperty('--calendar-height', ((window.innerWidth - leftMenuWidth) / calRatio).toString() + 'px');
 }
}

function getCookie(name) {
 var cookieArr = document.cookie.split(";");
 for (var i = 0; i < cookieArr.length; i++) {
  var cookiePair = cookieArr[i].split("=");
  if (name == cookiePair[0].trim()) {
   return decodeURIComponent(cookiePair[1]);
  }
 }
 return null;
}

function getCanvasSize(id) {
 var canvas = document.getElementById(id);
 var style = window.getComputedStyle(canvas);
 var height = $(window).height();
 return [canvas.clientWidth, height - canvas.offsetTop - (parseFloat(style.marginBottom) + 2)];
}

function getElementWidth(id) {
 var element = document.getElementById(id);
 var style = window.getComputedStyle(element); 
 return element.clientWidth;
}

function getRectangle(id) {
 var element = document.getElementById(id);
 return [element.offsetLeft, element.offsetTop, element.clientWidth, element.clientHeight];
}

function getViewPortRatio() {
 return window.innerWidth / window.innerHeight;
}

function getCanvasLocation(id) {
 var canvas = document.getElementById(id);
 return [canvas.offsetLeft, canvas.offsetTop];
}

function getPixelsInRem() {
 return parseFloat(getComputedStyle(document.documentElement).fontSize);
}

function getMediaWidth() {
 return Math.max(document.documentElement.clientWidth || 0, window.innerWidth || 0);
}

var helper;
window.addEventListener("resize", resizedWindow);

function resizedWindow() {
 setScreenRatio();
 if (helper != null) {
  helper.invokeMethodAsync('OnBrowserResize').then(data => data);
 } else {
  console.log('helper missing');
 }
};

function RegisterHelper(dotnetHelper) {
 helper = dotnetHelper;
}

function UnregisterHelper() {
 helper = null;
}

function SaveAsFile(filename, typ, bytesBase64) {
 if (navigator.msSaveBlob) {
  //Download document in Edge browser
  var data = window.atob(bytesBase64);
  var bytes = new Uint8Array(data.length);
  for (var i = 0; i < data.length; i++) {
   bytes[i] = data.charCodeAt(i);
  }
  var blob = new Blob([bytes.buffer], { type: typ });
  navigator.msSaveBlob(blob, filename);
 }
 else {
  var link = document.createElement('a');
  link.download = filename;
  link.href = "data:" + typ + ";base64," + bytesBase64;
  document.body.appendChild(link); // Needed for Firefox
  link.click();
  document.body.removeChild(link);
 }
}
