CREATE TABLE IF NOT EXISTS [LuxmeterExtension](
  [IdNode] INTEGER PRIMARY KEY
, [RealMin] int NOT NULL DEFAULT 0
, [RealMax] int NOT NULL DEFAULT 2040
, [CalibratedMin] int NOT NULL DEFAULT -1
, [CalibratedMax] int NOT NULL DEFAULT -1
);
INSERT INTO [LuxmeterExtension](IdNode) SELECT IdNode FROM Node n WHERE Type=0 AND State=1 AND NOT EXISTS (SELECT IdNode From LuxmeterExtension l WHERE n.IdNode=l.IdNode);

PRAGMA foreign_keys=off;

BEGIN TRANSACTION;

CREATE TABLE [Group_old] (
  [IdGroup] INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL
, [Name] text NULL
, [Description] text NULL
, [Power] int NULL
, [Value] int NULL
, [Auto] int NOT NULL DEFAULT 0
);

INSERT INTO [Group_old] ([IdGroup],[Name],[Description],[Power],[Value],[Auto])
  SELECT [IdGroup],[Name],[Description],[Power],[Value],[Auto]
  FROM [Group];

DROP TABLE Group;

CREATE TABLE [Group] (
  [IdGroup] INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL
, [Name] text NULL
, [Description] text NULL
, [Power] int NULL
, [Value] int NULL
, [Auto] int NOT NULL DEFAULT 0
, [ScadaAddress] int NOT NULL DEFAULT -1
, [HysteresisMin] int NOT NULL DEFAULT -1
, [HysteresisMax] int NOT NULL DEFAULT -1
);

INSERT INTO [Group] (IdGroup,[Name],[Description],[Power],[Value],[Auto])
  SELECT IdGroup,[Name],[Description],[Power],[Value],[Auto]
  FROM Group_old;

DROP TABLE Group_old;
COMMIT;

PRAGMA foreign_keys=on;