﻿function mySetCookie(name, value, days) {
 deleteAllCookies();
 var expires = "";
 var date = new Date();
 if (days) {
  date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
 }
 else {
  date.setTime(date.getTime() + (30 * 24 * 60 * 60 * 1000));
 }
 expires = "; expires=" + date.toUTCString();
 document.cookie = name + "=" + (value || "") + expires + "; path=/";
}

function myGetCookie(name) {
 var cookieArr = document.cookie.split(";");
 for (var i = 0; i < cookieArr.length; i++) {
  var cookiePair = cookieArr[i].split("=");
  if (name == cookiePair[0].trim()) {
   return decodeURIComponent(cookiePair[1]);
  }
 }
 return null;
}

function deleteAllCookies() {
 var cookies = document.cookie.split(";");

 for (var i = 0; i < cookies.length; i++) {
  var cookie = cookies[i];
  var eqPos = cookie.indexOf("=");
  var name = eqPos > -1 ? cookie.substr(0, eqPos) : cookie;
  document.cookie = name + "=;expires=Thu, 01 Jan 1970 00:00:00 GMT";
 }
}

function getCanvasSize(id) {
 var canvas = document.getElementById(id);
 var style = window.getComputedStyle(canvas);
 var height = $(window).height();
 return [canvas.clientWidth, height - canvas.offsetTop - (parseFloat(style.marginBottom) + 2)];
}

function getCanvasLocation(id) {
 var canvas = document.getElementById(id);
 return [canvas.offsetLeft, canvas.offsetTop];
}

var helper;
window.addEventListener("resize", resizedWindow);

function resizedWindow() {
 if (helper != null) {
  helper.invokeMethodAsync('OnBrowserResize').then(data => data);
 } else {
  console.log('helper missing');
 }
};

function RegisterHelper(dotnetHelper) {
 helper = dotnetHelper;
}

function UnregisterHelper() {
 helper = null;
}

//function StopTouch(id) {
// var element = document.getElementById(id);
// if (element != null) {
//  if (element.addEventListener) {
//   console.log('events');
//   element.addEventListener('touchstart', preventTouch, { passive: false });
//   element.addEventListener('touchmove', preventTouch, { passive: false });
//   element.addEventListener('touchend', preventTouch, { passive: false });
//  }
// }
//}

//function preventTouch(event) {
// console.log(event);
// event.preventDefault;
//}

function SaveAsFile(filename, typ, bytesBase64) {
 if (navigator.msSaveBlob) {
  //Download document in Edge browser
  var data = window.atob(bytesBase64);
  var bytes = new Uint8Array(data.length);
  for (var i = 0; i < data.length; i++) {
   bytes[i] = data.charCodeAt(i);
  }
  var blob = new Blob([bytes.buffer], { type: typ });
  navigator.msSaveBlob(blob, filename);
 }
 else {
  var link = document.createElement('a');
  link.download = filename;
  link.href = "data:" + typ + ";base64," + bytesBase64;
  document.body.appendChild(link); // Needed for Firefox
  link.click();
  document.body.removeChild(link);
 }
}


