"use strict";function getBoundingClientRect(e){e=e.getBoundingClientRect();return{width:e.width,height:e.height,top:e.top,right:e.right,bottom:e.bottom,left:e.left,x:e.left,y:e.top}}function getWindow(e){if("[object Window]"===e.toString())return e;e=e.ownerDocument;return e&&e.defaultView||window}function getWindowScroll(e){e=getWindow(e);return{scrollLeft:e.pageXOffset,scrollTop:e.pageYOffset}}function isElement(e){return e instanceof getWindow(e).Element||e instanceof Element}function isHTMLElement(e){return e instanceof getWindow(e).HTMLElement||e instanceof HTMLElement}function isShadowRoot(e){return e instanceof getWindow(e).ShadowRoot||e instanceof ShadowRoot}function getHTMLElementScroll(e){return{scrollLeft:e.scrollLeft,scrollTop:e.scrollTop}}function getNodeScroll(e){return(e!==getWindow(e)&&isHTMLElement(e)?getHTMLElementScroll:getWindowScroll)(e)}function getNodeName(e){return e?(e.nodeName||"").toLowerCase():null}function getDocumentElement(e){return((isElement(e)?e.ownerDocument:e.document)||window.document).documentElement}function getWindowScrollBarX(e){return getBoundingClientRect(getDocumentElement(e)).left+getWindowScroll(e).scrollLeft}function getComputedStyle(e){return getWindow(e).getComputedStyle(e)}function isScrollParent(e){var t=getComputedStyle(e),n=t.overflow,e=t.overflowX,t=t.overflowY;return/auto|scroll|overlay|hidden/.test(n+t+e)}function getCompositeRect(e,t,n){void 0===n&&(n=!1);var o=getDocumentElement(t),r=getBoundingClientRect(e),i=isHTMLElement(t),a={scrollLeft:0,scrollTop:0},e={x:0,y:0};return!i&&(i||n)||("body"===getNodeName(t)&&!isScrollParent(o)||(a=getNodeScroll(t)),isHTMLElement(t)?((e=getBoundingClientRect(t)).x+=t.clientLeft,e.y+=t.clientTop):o&&(e.x=getWindowScrollBarX(o))),{x:r.left+a.scrollLeft-e.x,y:r.top+a.scrollTop-e.y,width:r.width,height:r.height}}function getLayoutRect(e){return{x:e.offsetLeft,y:e.offsetTop,width:e.offsetWidth,height:e.offsetHeight}}function getParentNode(e){return"html"===getNodeName(e)?e:e.assignedSlot||e.parentNode||e.host||getDocumentElement(e)}function getScrollParent(e){return 0<=["html","body","#document"].indexOf(getNodeName(e))?e.ownerDocument.body:isHTMLElement(e)&&isScrollParent(e)?e:getScrollParent(getParentNode(e))}function listScrollParents(e,t){void 0===t&&(t=[]);var n=getScrollParent(e),o="body"===getNodeName(n),e=getWindow(n),n=o?[e].concat(e.visualViewport||[],isScrollParent(n)?n:[]):n,t=t.concat(n);return o?t:t.concat(listScrollParents(getParentNode(n)))}function isTableElement(e){return 0<=["table","td","th"].indexOf(getNodeName(e))}function getTrueOffsetParent(e){if(!isHTMLElement(e)||"fixed"===getComputedStyle(e).position)return null;var t=e.offsetParent;if(t){e=getDocumentElement(t);if("body"===getNodeName(t)&&"static"===getComputedStyle(t).position&&"static"!==getComputedStyle(e).position)return e}return t}function getContainingBlock(e){for(var t=getParentNode(e);isHTMLElement(t)&&["html","body"].indexOf(getNodeName(t))<0;){var n=getComputedStyle(t);if("none"!==n.transform||"none"!==n.perspective||n.willChange&&"auto"!==n.willChange)return t;t=t.parentNode}return null}function getOffsetParent(e){for(var t=getWindow(e),n=getTrueOffsetParent(e);n&&isTableElement(n)&&"static"===getComputedStyle(n).position;)n=getTrueOffsetParent(n);return(!n||"body"!==getNodeName(n)||"static"!==getComputedStyle(n).position)&&(n||getContainingBlock(e))||t}Object.defineProperty(exports,"__esModule",{value:!0});var top="top",bottom="bottom",right="right",left="left",auto="auto",basePlacements=[top,bottom,right,left],start="start",end="end",clippingParents="clippingParents",viewport="viewport",popper="popper",reference="reference",beforeRead="beforeRead",read="read",afterRead="afterRead",beforeMain="beforeMain",main="main",afterMain="afterMain",beforeWrite="beforeWrite",write="write",afterWrite="afterWrite",modifierPhases=[beforeRead,read,afterRead,beforeMain,main,afterMain,beforeWrite,write,afterWrite];function order(e){var n=new Map,o=new Set,r=[];return e.forEach(function(e){n.set(e.name,e)}),e.forEach(function(e){o.has(e.name)||!function t(e){o.add(e.name),[].concat(e.requires||[],e.requiresIfExists||[]).forEach(function(e){o.has(e)||(e=n.get(e))&&t(e)}),r.push(e)}(e)}),r}function orderModifiers(e){var n=order(e);return modifierPhases.reduce(function(e,t){return e.concat(n.filter(function(e){return e.phase===t}))},[])}function debounce(t){var n;return function(){return n=n||new Promise(function(e){Promise.resolve().then(function(){n=void 0,e(t())})})}}function format(e){for(var t=arguments.length,n=new Array(1<t?t-1:0),o=1;o<t;o++)n[o-1]=arguments[o];return[].concat(n).reduce(function(e,t){return e.replace(/%s/,t)},e)}var INVALID_MODIFIER_ERROR='Popper: modifier "%s" provided an invalid %s property, expected %s but got %s',MISSING_DEPENDENCY_ERROR='Popper: modifier "%s" requires "%s", but "%s" modifier is not available',VALID_PROPERTIES=["name","enabled","phase","fn","effect","requires","options"];function validateModifiers(o){o.forEach(function(n){Object.keys(n).forEach(function(e){switch(e){case"name":"string"!=typeof n.name&&console.error(format(INVALID_MODIFIER_ERROR,String(n.name),'"name"','"string"','"'+String(n.name)+'"'));break;case"enabled":"boolean"!=typeof n.enabled&&console.error(format(INVALID_MODIFIER_ERROR,n.name,'"enabled"','"boolean"','"'+String(n.enabled)+'"'));case"phase":modifierPhases.indexOf(n.phase)<0&&console.error(format(INVALID_MODIFIER_ERROR,n.name,'"phase"',"either "+modifierPhases.join(", "),'"'+String(n.phase)+'"'));break;case"fn":"function"!=typeof n.fn&&console.error(format(INVALID_MODIFIER_ERROR,n.name,'"fn"','"function"','"'+String(n.fn)+'"'));break;case"effect":"function"!=typeof n.effect&&console.error(format(INVALID_MODIFIER_ERROR,n.name,'"effect"','"function"','"'+String(n.fn)+'"'));break;case"requires":Array.isArray(n.requires)||console.error(format(INVALID_MODIFIER_ERROR,n.name,'"requires"','"array"','"'+String(n.requires)+'"'));break;case"requiresIfExists":Array.isArray(n.requiresIfExists)||console.error(format(INVALID_MODIFIER_ERROR,n.name,'"requiresIfExists"','"array"','"'+String(n.requiresIfExists)+'"'));break;case"options":case"data":break;default:console.error('PopperJS: an invalid property has been provided to the "'+n.name+'" modifier, valid properties are '+VALID_PROPERTIES.map(function(e){return'"'+e+'"'}).join(", ")+'; but "'+e+'" was provided.')}n.requires&&n.requires.forEach(function(t){null==o.find(function(e){return e.name===t})&&console.error(format(MISSING_DEPENDENCY_ERROR,String(n.name),t,t))})})})}function uniqueBy(e,t){var n=new Set;return e.filter(function(e){e=t(e);if(!n.has(e))return n.add(e),!0})}function getBasePlacement(e){return e.split("-")[0]}function mergeByName(e){var t=e.reduce(function(e,t){var n=e[t.name];return e[t.name]=n?Object.assign(Object.assign(Object.assign({},n),t),{},{options:Object.assign(Object.assign({},n.options),t.options),data:Object.assign(Object.assign({},n.data),t.data)}):t,e},{});return Object.keys(t).map(function(e){return t[e]})}function getViewportRect(e){var t=getWindow(e),n=getDocumentElement(e),o=t.visualViewport,r=n.clientWidth,i=n.clientHeight,t=0,n=0;return o&&(r=o.width,i=o.height,/^((?!chrome|android).)*safari/i.test(navigator.userAgent)||(t=o.offsetLeft,n=o.offsetTop)),{width:r,height:i,x:t+getWindowScrollBarX(e),y:n}}function getDocumentRect(e){var t=getDocumentElement(e),n=getWindowScroll(e),o=e.ownerDocument.body,r=Math.max(t.scrollWidth,t.clientWidth,o?o.scrollWidth:0,o?o.clientWidth:0),i=Math.max(t.scrollHeight,t.clientHeight,o?o.scrollHeight:0,o?o.clientHeight:0),e=-n.scrollLeft+getWindowScrollBarX(e),n=-n.scrollTop;return"rtl"===getComputedStyle(o||t).direction&&(e+=Math.max(t.clientWidth,o?o.clientWidth:0)-r),{width:r,height:i,x:e,y:n}}function contains(e,t){var n=t.getRootNode&&t.getRootNode();if(e.contains(t))return!0;if(n&&isShadowRoot(n)){var o=t;do{if(o&&e.isSameNode(o))return!0}while(o=o.parentNode||o.host)}return!1}function rectToClientRect(e){return Object.assign(Object.assign({},e),{},{left:e.x,top:e.y,right:e.x+e.width,bottom:e.y+e.height})}function getInnerBoundingClientRect(e){var t=getBoundingClientRect(e);return t.top=t.top+e.clientTop,t.left=t.left+e.clientLeft,t.bottom=t.top+e.clientHeight,t.right=t.left+e.clientWidth,t.width=e.clientWidth,t.height=e.clientHeight,t.x=t.left,t.y=t.top,t}function getClientRectFromMixedType(e,t){return t===viewport?rectToClientRect(getViewportRect(e)):isHTMLElement(t)?getInnerBoundingClientRect(t):rectToClientRect(getDocumentRect(getDocumentElement(e)))}function getClippingParents(e){var t=listScrollParents(getParentNode(e)),n=0<=["absolute","fixed"].indexOf(getComputedStyle(e).position)&&isHTMLElement(e)?getOffsetParent(e):e;return isElement(n)?t.filter(function(e){return isElement(e)&&contains(e,n)&&"body"!==getNodeName(e)}):[]}function getClippingRect(n,e,t){e="clippingParents"===e?getClippingParents(n):[].concat(e),e=[].concat(e,[t]),t=e[0],t=e.reduce(function(e,t){t=getClientRectFromMixedType(n,t);return e.top=Math.max(t.top,e.top),e.right=Math.min(t.right,e.right),e.bottom=Math.min(t.bottom,e.bottom),e.left=Math.max(t.left,e.left),e},getClientRectFromMixedType(n,t));return t.width=t.right-t.left,t.height=t.bottom-t.top,t.x=t.left,t.y=t.top,t}function getVariation(e){return e.split("-")[1]}function getMainAxisFromPlacement(e){return 0<=["top","bottom"].indexOf(e)?"x":"y"}function computeOffsets(e){var t,n=e.reference,o=e.element,r=e.placement,i=r?getBasePlacement(r):null,a=r?getVariation(r):null,e=n.x+n.width/2-o.width/2,r=n.y+n.height/2-o.height/2;switch(i){case top:t={x:e,y:n.y-o.height};break;case bottom:t={x:e,y:n.y+n.height};break;case right:t={x:n.x+n.width,y:r};break;case left:t={x:n.x-o.width,y:r};break;default:t={x:n.x,y:n.y}}r=i?getMainAxisFromPlacement(i):null;if(null!=r){i="y"===r?"height":"width";switch(a){case start:t[r]=t[r]-(n[i]/2-o[i]/2);break;case end:t[r]=t[r]+(n[i]/2-o[i]/2)}}return t}function getFreshSideObject(){return{top:0,right:0,bottom:0,left:0}}function mergePaddingObject(e){return Object.assign(Object.assign({},getFreshSideObject()),e)}function expandToHashMap(n,e){return e.reduce(function(e,t){return e[t]=n,e},{})}function detectOverflow(e,t){void 0===t&&(t={});var o,n=t.placement,r=void 0===n?e.placement:n,i=t.boundary,a=void 0===i?clippingParents:i,c=t.rootBoundary,s=void 0===c?viewport:c,l=t.elementContext,f=void 0===l?popper:l,n=t.altBoundary,i=void 0!==n&&n,c=t.padding,l=void 0===c?0:c,n=mergePaddingObject("number"!=typeof l?l:expandToHashMap(l,basePlacements)),t=f===popper?reference:popper,c=e.elements.reference,l=e.rects.popper,t=e.elements[i?t:f],a=getClippingRect(isElement(t)?t:t.contextElement||getDocumentElement(e.elements.popper),a,s),s=getBoundingClientRect(c),c=computeOffsets({reference:s,element:l,strategy:"absolute",placement:r}),c=rectToClientRect(Object.assign(Object.assign({},l),c)),s=f===popper?c:s,d={top:a.top-s.top+n.top,bottom:s.bottom-a.bottom+n.bottom,left:a.left-s.left+n.left,right:s.right-a.right+n.right},e=e.modifiersData.offset;return f===popper&&e&&(o=e[r],Object.keys(d).forEach(function(e){var t=0<=[right,bottom].indexOf(e)?1:-1,n=0<=[top,bottom].indexOf(e)?"y":"x";d[e]+=o[n]*t})),d}var INVALID_ELEMENT_ERROR="Popper: Invalid reference or popper argument provided. They must be either a DOM element or virtual element.",INFINITE_LOOP_ERROR="Popper: An infinite loop in the modifiers cycle has been detected! The cycle has been interrupted to prevent a browser crash.",DEFAULT_OPTIONS={placement:"bottom",modifiers:[],strategy:"absolute"};function areValidElements(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return!t.some(function(e){return!(e&&"function"==typeof e.getBoundingClientRect)})}function popperGenerator(e){void 0===e&&(e={});var t=e.defaultModifiers,a=void 0===t?[]:t,e=e.defaultOptions,f=void 0===e?DEFAULT_OPTIONS:e;return function(t,n,o){void 0===o&&(o=f);var c={placement:"bottom",orderedModifiers:[],options:Object.assign(Object.assign({},DEFAULT_OPTIONS),f),modifiersData:{},elements:{reference:t,popper:n},attributes:{},styles:{}},r=[],s=!1,l={state:c,setOptions:function(e){i(),c.options=Object.assign(Object.assign(Object.assign({},f),c.options),e),c.scrollParents={reference:isElement(t)?listScrollParents(t):t.contextElement?listScrollParents(t.contextElement):[],popper:listScrollParents(n)};e=orderModifiers(mergeByName([].concat(a,c.options.modifiers)));return c.orderedModifiers=e.filter(function(e){return e.enabled}),"production"!==process.env.NODE_ENV&&(validateModifiers(uniqueBy([].concat(e,c.options.modifiers),function(e){return e.name})),getBasePlacement(c.options.placement)===auto&&(c.orderedModifiers.find(function(e){return"flip"===e.name})||console.error(['Popper: "auto" placements require the "flip" modifier be',"present and enabled to work."].join(" "))),[(e=getComputedStyle(n)).marginTop,e.marginRight,e.marginBottom,e.marginLeft].some(function(e){return parseFloat(e)})&&console.warn(['Popper: CSS "margin" styles cannot be used to apply padding',"between the popper and its reference element or boundary.","To replicate margin, use the `offset` modifier, as well as","the `padding` option in the `preventOverflow` and `flip`","modifiers."].join(" "))),c.orderedModifiers.forEach(function(e){var t=e.name,n=e.options,n=void 0===n?{}:n,e=e.effect;"function"==typeof e&&(n=e({state:c,name:t,instance:l,options:n}),r.push(n||function(){}))}),l.update()},forceUpdate:function(){if(!s){var e=c.elements,t=e.reference,e=e.popper;if(areValidElements(t,e)){c.rects={reference:getCompositeRect(t,getOffsetParent(e),"fixed"===c.options.strategy),popper:getLayoutRect(e)},c.reset=!1,c.placement=c.options.placement,c.orderedModifiers.forEach(function(e){return c.modifiersData[e.name]=Object.assign({},e.data)});for(var n,o,r,i=0,a=0;a<c.orderedModifiers.length;a++){if("production"!==process.env.NODE_ENV&&100<(i+=1)){console.error(INFINITE_LOOP_ERROR);break}!0!==c.reset?(n=(r=c.orderedModifiers[a]).fn,o=void 0===(o=r.options)?{}:o,r=r.name,"function"==typeof n&&(c=n({state:c,options:o,name:r,instance:l})||c)):(c.reset=!1,a=-1)}}else"production"!==process.env.NODE_ENV&&console.error(INVALID_ELEMENT_ERROR)}},update:debounce(function(){return new Promise(function(e){l.forceUpdate(),e(c)})}),destroy:function(){i(),s=!0}};return areValidElements(t,n)?l.setOptions(o).then(function(e){!s&&o.onFirstUpdate&&o.onFirstUpdate(e)}):"production"!==process.env.NODE_ENV&&console.error(INVALID_ELEMENT_ERROR),l;function i(){r.forEach(function(e){return e()}),r=[]}}}var createPopper=popperGenerator();exports.createPopper=createPopper,exports.detectOverflow=detectOverflow,exports.popperGenerator=popperGenerator;